<?php

/*

 Website Baker Project <http://www.websitebaker.org/>
 Copyright (C) 2004-2006, Ryan Djurovich

 Website Baker is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Website Baker is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Website Baker; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

require('../../config.php');

// Include WB admin wrapper script
require(WB_PATH.'/modules/admin.php');

// Load Language file
if(LANGUAGE_LOADED) {
	if(!file_exists(WB_PATH.'/modules/FancyBraxBox/languages/'.LANGUAGE.'.php')) {
		require_once(WB_PATH.'/modules/FancyBraxBox/languages/EN.php');
	} else {
		require_once(WB_PATH.'/modules/FancyBraxBox/languages/'.LANGUAGE.'.php');
	}
}

// Get header and footer
$query_content = $database->query("SELECT * FROM ".TABLE_PREFIX."mod_fancybrax_settings WHERE section_id = '$section_id'");
$fetch_content = $query_content->fetchRow();
/*
$fetch_content['ordering']
0 - ascending position
1 - descending position
2 - ascending title
3 - descending title
4 - ascending when
5 - descending when

orderby:
position=0
title=1
when=2
*/

// Set raw html <'s and >'s to be replace by friendly html code
$raw = array('<', '>');
$friendly = array('&lt;', '&gt;');

?>

<style type="text/css">
.setting_name {
	vertical-align: top;
}
.newsection {
	border-top: 1px dashed #ffffff;
	vertical-align: top;
}
</style>

<form name="modify" action="<?php echo WB_URL; ?>/modules/FancyBraxBox/save_settings.php" method="post" style="margin: 0;">

<input type="hidden" name="section_id" value="<?php echo $section_id; ?>">
<input type="hidden" name="page_id" value="<?php echo $page_id; ?>">

<table class="row_a" cellpadding="2" cellspacing="0" border="0" width="100%">
	<tr>
		<td colspan="2"><strong><?php echo $GTEXT['GSETTINGS']; ?></strong></td>
	</tr>
	<?php if(extension_loaded('gd') AND function_exists('imageCreateFromJpeg')) { /* Make's sure GD library is installed */ ?>
	<tr>
		<td class="setting_name" width="25%"><?php echo $GTEXT['MAIN_RESIZE_IMAGE_TO']; ?>:</td>
		<td class="setting_name"><input type="text" name="main_resize" value="<? echo $fetch_content['main_resize']; ?>" style="width: 30px;" maxlength="3" /> pixel</td>
	</tr>
	<tr>
		<td class="setting_name" width="25%"><?php echo $GTEXT['THUMB_RESIZE_IMAGE_TO']; ?>:</td>
		<td class="setting_name"><input type="text" name="thmb_resize" value="<? echo $fetch_content['thmb_resize']; ?>" style="width: 30px;" maxlength="3" /> pixel</td>
	</tr>
	<?php } ?>
	<tr>
		<td class="setting_name" width="25%"><?php echo $GTEXT['IMAGES_PER_PAGE']; ?>:</td>
		<td class="setting_name"><input type="text" name="images_per_page" value="<? echo $fetch_content['images_per_page']; ?>" style="width: 30px" > 0 = <?php echo $TEXT['UNLIMITED']; ?></td>
	</tr>
	<tr>
		<td class="setting_name" width="25%"><?php echo $GTEXT['NUMBER_OF_COLUMS']; ?>:</td>
		<td class="setting_name"><select name="num_cols" style="width: 50px">
			<?php
			for($i = 1; $i <= 10; $i++) {
				if($fetch_content['num_cols'] == $i) { $selected = ' selected'; } else { $selected = ''; }
				echo '<option value="'.$i.'"'.$selected.'>'.$i.'</option>';
			}
			?>
			</select>
		</td>
	</tr>
	<?PHP 
	$nocheck="";
	$newcheck="";
	$parentcheck="";
		
	$imagelink=$fetch_content['imagelink'];
	if($imagelink==""){$imagelink=0;}
	switch($imagelink){
		case 0:
			$nocheck="checked";
			break;
		case 1:
			$parentcheck="checked";
			break;
		case 2:
			$newcheck="checked";
			break;
		}
	
	?>
	
	<tr>
		<td class="setting_name" width="25%"><?php echo $GTEXT['IMAGELINK']; ?>:</td>
		<td class="setting_name">
		<input type="radio" name="imagelink" value="0" <?php echo $nocheck; ?>><?php echo $GTEXT['NOLINK']; ?><br>
		<input type="radio" name="imagelink" value="1" <?php echo $parentcheck; ?>><?php echo $GTEXT['PARENTLINK']; ?><br>
		<input type="radio" name="imagelink" value="2" <?php echo $newcheck; ?>><?php echo $GTEXT['NEWLINK']; ?>
		</td>
	</tr>

	<tr>
	    <td class="setting_name" width="25%"><?php echo $GTEXT['ORDERING']; ?>:</td>
	    <td class="setting_name">
	        <select name="ordering" style="width: 200px">
	            <?php
	            if (
	            $fetch_content['ordering'] == '0' 
	            or $fetch_content['ordering'] == '2' 
	            or $fetch_content['ordering'] == '4'
	            ) {
	                $selected_asc = 'selected';
	                $selected_desc = '';
	            } else {
	                $selected_asc = '';
	                $selected_desc = 'selected';
	            }
	            ?>
	            <option value="0" <?php echo $selected_asc; ?>><?php echo $GTEXT['ASCENDING']; ?></option>
	            <option value="1" <?php echo $selected_desc; ?>><?php echo $GTEXT['DESCENDING']; ?></option>
	        </select>
	    </td>
	</tr>
	<tr>
	    <td class="setting_name" width="25%"><?php echo $GTEXT['ORDERBY']; ?>:</td>
	    <td class="setting_name">
	        <select name="orderby" style="width: 200px">
	            <?php
	    		if ($fetch_content['ordering'] == '4' or $fetch_content['ordering'] == '5')
	    		{
	                $selected_position = '';
	                $selected_title = '';
	                $selected_when = 'selected';
	            } elseif ($fetch_content['ordering'] == '2' or $fetch_content['ordering'] == '3') 
	            {
	                $selected_position = '';
	                $selected_title = 'selected';
	                $selected_when = '';
	            }else{
	                $selected_position = 'selected';
	                $selected_title = '';
	                $selected_when = '';
                }
	            ?>
	            <option value="0" <?php echo $selected_position; ?>><?php echo $GTEXT['POSITION']; ?></option>
	            <option value="1" <?php echo $selected_title; ?>><?php echo $GTEXT['TITLE']; ?></option>
	            <option value="2" <?php echo $selected_when; ?>><?php echo $GTEXT['WHEN']; ?></option>
	        </select>
	    </td>
	</tr>
	
	
	
	
	
	
	
	
	
	
	
	
</table>

<table class="row_a" cellpadding="2" cellspacing="0" border="0" width="100%" style="margin-top: 5px;">
	<tr>
		<td colspan="2"><strong><?php echo $GTEXT['LSETTINGS']; ?></strong></td>
	</tr>
	<tr>
		<td class="setting_name" width="25%"><?php echo $TEXT['HEADER']; ?>:</td>
		<td class="setting_name"><textarea name="header" style="width: 98%; height: 80px;"><?php echo stripslashes($fetch_content['header']); ?></textarea></td>
	</tr>
	<tr>
		<td class="setting_name" width="25%"><?php echo $TEXT['LOOP']; ?>:</td>
		<td class="setting_name"><textarea name="image_loop" style="width: 98%; height: 80px;"><?php echo stripslashes($fetch_content['image_loop']); ?></textarea></td>
	</tr>
	<tr>
		<td class="setting_name" width="25%"><?php echo $TEXT['FOOTER']; ?>:</td>
		<td class="setting_name"><textarea name="footer" style="width: 98%; height: 80px;"><?php echo str_replace($raw, $friendly, stripslashes($fetch_content['footer'])); ?></textarea></td>
	</tr>
	<tr>
		<td class="newsection" width="25%"><?php echo $TEXT['IMAGE'].' '.$TEXT['HEADER']; ?>:</td>
		<td class="newsection"><textarea name="image_header" style="width: 98%; height: 80px;"><?php echo str_replace($raw, $friendly, stripslashes($fetch_content['image_header'])); ?></textarea></td>
	</tr>
	<tr>
		<td class="setting_name" width="25%"><?php echo $TEXT['IMAGE'].' '.$TEXT['FOOTER']; ?>:</td>
		<td class="setting_name"><textarea name="image_footer" style="width: 98%; height: 80px;"><?php echo str_replace($raw, $friendly, stripslashes($fetch_content['image_footer'])); ?></textarea></td>
	</tr>
</table>	
	
<table cellpadding="0" cellspacing="0" border="0" width="100%">
	<tr>
		<td align="left">
			<input name="save" type="submit" value="<?php echo $TEXT['SAVE']; ?>" style="width: 100px; margin-top: 5px;"></form>
		</td>
		<td align="right">
			<input type="button" value="<?php echo $TEXT['CANCEL']; ?>" onclick="javascript: window.location = '<?php echo ADMIN_URL; ?>/pages/modify.php?page_id=<?php echo $page_id; ?>';" style="width: 100px; margin-top: 5px;" />
		</td>
	</tr>
</table>

<?php

// Print admin footer
$admin->print_footer();

?>